<?php
session_start();
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    header('Location: admin_login.php');
    exit;
}

if (!isset($_GET['assignment_id']) || !is_numeric($_GET['assignment_id'])) {
    header('Location: manage_students.php');
    exit;
}

$assignment_id = (int)$_GET['assignment_id'];

$host = 'localhost';
$dbname = 'mcq_exam_portal';
$user = 'root';
$pass = '';

try {
    $pdo = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8mb4", $user, $pass);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Delete the assignment
    $stmt = $pdo->prepare("DELETE FROM student_exams WHERE id = ?");
    $stmt->execute([$assignment_id]);

    header('Location: manage_students.php?msg=Assignment+removed+successfully');
    exit;
} catch (PDOException $e) {
    die("Error removing assignment: " . $e->getMessage());
}
?>
