<?php
session_start();
if(!isset($_SESSION['admin_logged_in'])||$_SESSION['admin_logged_in']!==true){header('Location: admin_login.php');exit;}
require_once 'connectiondb.php';

try{$pdo=new PDO("mysql:host=$host;dbname=$dbname;charset=utf8mb4",$user,$pass);$pdo->setAttribute(PDO::ATTR_ERRMODE,PDO::ERRMODE_EXCEPTION);}catch(PDOException $e){die("Database connection failed: ".$e->getMessage());}
$error='';$success='';
if($_SERVER['REQUEST_METHOD']==='POST'){
    if(isset($_POST['add_student'])){
        $student_id=trim($_POST['student_id']??'');
        $name=trim($_POST['name']??'');
        if(empty($student_id)||empty($name)){$error="Please enter both Student ID and Name.";}
        else{
            $stmt=$pdo->prepare("SELECT id FROM students WHERE student_id=?");
            $stmt->execute([$student_id]);
            if($stmt->fetch()){
                $stmt=$pdo->prepare("UPDATE students SET name=? WHERE student_id=?");
                $stmt->execute([$name,$student_id]);
                $success="Student updated successfully.";
            }else{
                $stmt=$pdo->prepare("INSERT INTO students (student_id,name,password_hash) VALUES (?,?, '')");
                $stmt->execute([$student_id,$name]);
                $success="Student added successfully.";
            }
        }
    }elseif(isset($_POST['assign_exam'])){
        $student_id=$_POST['student_id_assign']??'';
        $exam_id=$_POST['exam_id']??'';
        if(empty($student_id)||empty($exam_id)){$error="Please select both student and exam to assign.";}
        else{
            $stmt=$pdo->prepare("SELECT id FROM student_exams WHERE student_id=? AND exam_id=?");
            $stmt->execute([$student_id,$exam_id]);
            if($stmt->fetch()){$error="This exam is already assigned to the student.";}
            else{
                $stmt=$pdo->prepare("INSERT INTO student_exams (student_id,exam_id,status) VALUES (?,?, 'assigned')");
                $stmt->execute([$student_id,$exam_id]);
                $success="Exam assigned to student successfully.";
            }
        }
    }elseif(isset($_POST['bulk_assign'])){
        $student_ids = $_POST['bulk_student_ids'] ?? [];
        $exam_id = $_POST['bulk_exam_id'] ?? '';
        if(empty($student_ids) || empty($exam_id)){
            $error = "Please select students and an exam for bulk assignment.";
        } else {
            $assigned_count = 0;
            $already_assigned_count = 0;
            $pdo->beginTransaction();
            try {
                $stmtCheck = $pdo->prepare("SELECT id FROM student_exams WHERE student_id = ? AND exam_id = ?");
                $stmtInsert = $pdo->prepare("INSERT INTO student_exams (student_id, exam_id, status) VALUES (?, ?, 'assigned')");
                foreach($student_ids as $student_id){
                    if(!is_numeric($student_id)) continue;
                    $stmtCheck->execute([$student_id, $exam_id]);
                    if($stmtCheck->fetch()){
                        $already_assigned_count++;
                    } else {
                        $stmtInsert->execute([$student_id, $exam_id]);
                        $assigned_count++;
                    }
                }
                $pdo->commit();
                $success = "Bulk assignment completed. Exams assigned: $assigned_count. Already assigned: $already_assigned_count.";
            } catch (Exception $e) {
                $pdo->rollBack();
                $error = "Error during bulk assignment: " . $e->getMessage();
            }
        }
    }elseif(isset($_POST['bulk_upload'])){
        if(!isset($_FILES['bulk_file'])||$_FILES['bulk_file']['error']!==UPLOAD_ERR_OK){$error="Error uploading file.";}
        else{
            $exam_id=$_POST['bulk_exam_id']??'';
            if(empty($exam_id)){$error="Please select an exam for bulk upload.";}
            else{
                $file=$_FILES['bulk_file']['tmp_name'];
                $handle=fopen($file,'r');
                if($handle===false){$error="Failed to open uploaded file.";}
                else{
                    $row=0;$added=0;$assigned=0;
                    while(($data=fgetcsv($handle))!==false){
                        $row++;
                        if($row==1)continue;
                        $student_id=trim($data[0]??'');
                        $name=trim($data[1]??'');
                        if(empty($student_id)||empty($name))continue;
                        $stmt=$pdo->prepare("SELECT id FROM students WHERE student_id=?");
                        $stmt->execute([$student_id]);
                        $student=$stmt->fetch(PDO::FETCH_ASSOC);
                        if(!$student){
                            $stmt=$pdo->prepare("INSERT INTO students (student_id,name,password_hash) VALUES (?,?, '')");
                            $stmt->execute([$student_id,$name]);
                            $student_id_db=$pdo->lastInsertId();
                            $added++;
                        }else{$student_id_db=$student['id'];}
                        $stmt=$pdo->prepare("SELECT id FROM student_exams WHERE student_id=? AND exam_id=?");
                        $stmt->execute([$student_id_db,$exam_id]);
                        if(!$stmt->fetch()){
                            $stmt=$pdo->prepare("INSERT INTO student_exams (student_id,exam_id,status) VALUES (?,?, 'assigned')");
                            $stmt->execute([$student_id_db,$exam_id]);
                            $assigned++;
                        }
                    }
                    fclose($handle);
                    $success="Bulk upload completed. Students added: $added, Exams assigned: $assigned.";
                }
            }
        }
    }elseif(isset($_POST['reapprove_exam'])){
        $assignment_id=$_POST['assignment_id']??'';
        if(empty($assignment_id)){$error="Invalid assignment.";}
        else{
            $stmt=$pdo->prepare("UPDATE student_exams SET status='assigned', completed_at=NULL WHERE id=?");
            $stmt->execute([$assignment_id]);
            $success="Student re-approved for exam.";
        }
        // Redirect to avoid form resubmission on refresh
        header("Location: manage_students.php");
        exit;
    }
}
$students_per_page = 10;
$assignments_per_page = 10;

// Get current page numbers from GET parameters, default to 1
$students_page = isset($_GET['students_page']) && is_numeric($_GET['students_page']) && $_GET['students_page'] > 0 ? (int)$_GET['students_page'] : 1;
$assignments_page = isset($_GET['assignments_page']) && is_numeric($_GET['assignments_page']) && $_GET['assignments_page'] > 0 ? (int)$_GET['assignments_page'] : 1;

// Calculate OFFSET for SQL queries
$students_offset = ($students_page - 1) * $students_per_page;
$assignments_offset = ($assignments_page - 1) * $assignments_per_page;

// Get total counts for pagination
$stmt_count_students = $pdo->query("SELECT COUNT(*) FROM students");
$total_students = (int)$stmt_count_students->fetchColumn();

$stmt_count_assignments = $pdo->query("SELECT COUNT(*) FROM student_exams");
$total_assignments = (int)$stmt_count_assignments->fetchColumn();

// Fetch paginated students
$stmt = $pdo->prepare("SELECT id, student_id, name FROM students ORDER BY name ASC LIMIT :limit OFFSET :offset");
$stmt->bindValue(':limit', $students_per_page, PDO::PARAM_INT);
$stmt->bindValue(':offset', $students_offset, PDO::PARAM_INT);
$stmt->execute();
$students = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Fetch exams for dropdown (no change)
$stmt = $pdo->query("SELECT id, exam_name FROM exams ORDER BY exam_name ASC");
$exams = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Fetch paginated assignments
$stmt = $pdo->prepare("SELECT se.id, se.student_id, se.exam_id, s.student_id AS stud_id, s.name, e.exam_name, se.status, se.completed_at 
                       FROM student_exams se 
                       JOIN students s ON se.student_id = s.id 
                       JOIN exams e ON se.exam_id = e.id 
                       ORDER BY s.name, e.exam_name 
                       LIMIT :limit OFFSET :offset");
$stmt->bindValue(':limit', $assignments_per_page, PDO::PARAM_INT);
$stmt->bindValue(':offset', $assignments_offset, PDO::PARAM_INT);
$stmt->execute();
$assignments = $stmt->fetchAll(PDO::FETCH_ASSOC);
function canRemove($completed_at){
    if(!$completed_at) return false;
    $completed_time=strtotime($completed_at);
    $now=time();
    return ($now - $completed_time) > 10*24*3600;
}

// Calculate total pages for pagination
$total_students_pages = ceil($total_students / $students_per_page);
$total_assignments_pages = ceil($total_assignments / $assignments_per_page);
?>
<!DOCTYPE html><html><head><title>Manage Students - Admin Panel</title><link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet"/>
<style>
    body {
        background-color: #f8f9fa;
    }
    h2, h3 {
        color: #343a40;
    }
    .btn-primary {
        background-color: #007bff;
        border-color: #007bff;
    }
    .btn-primary:hover {
        background-color: #0056b3;
        border-color: #004085;
    }
    .btn-secondary {
        background-color: #6c757d;
        border-color: #6c757d;
    }
    .btn-secondary:hover {
        background-color: #5a6268;
        border-color: #545b62;
    }
    .btn-danger {
        background-color: #dc3545;
        border-color: #dc3545;
    }
    .btn-danger:hover {
        background-color: #bd2130;
        border-color: #b21f2d;
    }
    table.table-bordered {
        background-color: #ffffff;
    }
    .table-striped > tbody > tr:nth-of-type(odd) {
        background-color: #e9ecef;
    }
    .form-label {
        font-weight: 600;
        color: #495057;
    }
    .alert-danger {
        background-color: #f8d7da;
        color: #721c24;
        border-color: #f5c6cb;
    }
    .alert-success {
        background-color: #d4edda;
        color: #155724;
        border-color: #c3e6cb;
    }
</style>
</head><body>
<?php include 'navbar.php'; ?>
<div class="container my-4">
    <h2>Manage Students</h2>
    <?php if($error): ?>
        <div class="alert alert-danger"><?php echo htmlspecialchars($error); ?></div>
    <?php endif; ?>
    <?php if($success): ?>
        <div class="alert alert-success"><?php echo htmlspecialchars($success); ?></div>
    <?php endif; ?>

    <div class="row g-4">
        <div class="col-md-6">
            <div class="card shadow-sm">
                <div class="card-header bg-primary text-white">
                    <h3 class="card-title mb-0">Add or Edit Student</h3>
                </div>
                <div class="card-body">
                    <form method="POST" action="manage_students.php" id="studentForm">
                        <input type="hidden" name="add_student" value="1">
                        <div class="mb-3">
                            <label for="student_id" class="form-label">Student ID</label>
                            <input type="text" class="form-control" id="student_id" name="student_id" required>
                        </div>
                        <div class="mb-3">
                            <label for="name" class="form-label">Name</label>
                            <input type="text" class="form-control" id="name" name="name" required>
                        </div>
                        <button type="submit" class="btn btn-primary w-100">Add / Update Student</button>
                    </form>
                </div>
            </div>
        </div>

        <div class="col-md-6">
            <div class="card shadow-sm">
                <div class="card-header bg-primary text-white">
                    <h3 class="card-title mb-0">Assign Exam to Student</h3>
                </div>
                <div class="card-body">
                    <form method="POST" action="manage_students.php">
                        <input type="hidden" name="assign_exam" value="1">
                        <div class="mb-3">
                            <label for="student_id_assign" class="form-label">Select Student</label>
                            <select class="form-select" id="student_id_assign" name="student_id_assign" required>
                                <option value="">-- Select Student --</option>
                                <?php foreach($students as $student): ?>
                                <option value="<?php echo $student['id']; ?>"><?php echo htmlspecialchars($student['name']) . " (" . htmlspecialchars($student['student_id']) . ")"; ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                        <div class="mb-3">
                            <label for="exam_id" class="form-label">Select Exam</label>
                            <select class="form-select" id="exam_id" name="exam_id" required>
                                <option value="">-- Select Exam --</option>
                                <?php foreach($exams as $exam): ?>
                                <option value="<?php echo $exam['id']; ?>"><?php echo htmlspecialchars($exam['exam_name']); ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                        <button type="submit" class="btn btn-primary w-100">Assign Exam</button>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <div class="row g-4 mt-3">
        <div class="col-md-6">
            <div class="card shadow-sm">
                <div class="card-header bg-primary text-white">
                    <h3 class="card-title mb-0">Existing Students</h3>
                </div>
                <div class="card-body p-0">
                    <?php if(empty($students)): ?>
                        <p class="p-3">No students found.</p>
                    <?php else: ?>
                        <table class="table table-bordered table-striped mb-0">
                            <thead>
                                <tr>
                                    <th>Student ID</th>
                                    <th>Name</th>
                                    <th>Edit</th>
                                    <th>Delete</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach($students as $student): ?>
                                <tr>
                                    <td><?php echo htmlspecialchars($student['student_id']); ?></td>
                                    <td><?php echo htmlspecialchars($student['name']); ?></td>
                                    <td><button class="btn btn-sm btn-secondary edit-btn" data-studentid="<?php echo htmlspecialchars($student['student_id']); ?>" data-name="<?php echo htmlspecialchars($student['name']); ?>" title="Edit Student"><i class="bi bi-pencil"></i> Edit</button></td>
                                    <td><a href="delete_student.php?student_id=<?php echo $student['id']; ?>" class="btn btn-sm btn-danger" onclick="return confirm('Are you sure you want to delete this student? This will remove all related data.');" title="Delete Student"><i class="bi bi-trash"></i> Delete</a></td>
                                </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                        <nav aria-label="Students pagination" class="mt-2">
                            <ul class="pagination justify-content-center mb-0">
                                <li class="page-item <?php if($students_page <= 1) echo 'disabled'; ?>">
                                    <a class="page-link" href="?students_page=<?php echo $students_page - 1; ?>&assignments_page=<?php echo $assignments_page; ?>">Previous</a>
                                </li>
                                <li class="page-item disabled">
                                    <span class="page-link">Page <?php echo $students_page; ?> of <?php echo $total_students_pages; ?></span>
                                </li>
                                <li class="page-item <?php if($students_page >= $total_students_pages) echo 'disabled'; ?>">
                                    <a class="page-link" href="?students_page=<?php echo $students_page + 1; ?>&assignments_page=<?php echo $assignments_page; ?>">Next</a>
                                </li>
                            </ul>
                        </nav>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        <div class="col-md-6">
            <div class="card shadow-sm">
                <div class="card-header bg-primary text-white">
                    <h3 class="card-title mb-0">Assign Exam to Multiple Students (Bulk)</h3>
                </div>
                <div class="card-body">
                    <form method="POST" action="manage_students.php">
                        <input type="hidden" name="bulk_assign" value="1">
                        <div class="mb-3">
                            <label for="bulk_student_ids" class="form-label">Select Students</label>
                            <select class="form-select" id="bulk_student_ids" name="bulk_student_ids[]" multiple size="10" required>
                                <?php foreach($students as $student): ?>
                                <option value="<?php echo $student['id']; ?>"><?php echo htmlspecialchars($student['name']) . " (" . htmlspecialchars($student['student_id']) . ")"; ?></option>
                                <?php endforeach; ?>
                            </select>
                            <small class="form-text text-muted">Hold Ctrl (Cmd on Mac) to select multiple students.</small>
                        </div>
                        <div class="mb-3">
                            <label for="bulk_exam_id" class="form-label">Select Exam</label>
                            <select class="form-select" id="bulk_exam_id" name="bulk_exam_id" required>
                                <option value="">-- Select Exam --</option>
                                <?php foreach($exams as $exam): ?>
                                <option value="<?php echo $exam['id']; ?>"><?php echo htmlspecialchars($exam['exam_name']); ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                        <button type="submit" class="btn btn-primary w-100">Assign Exam to Selected Students</button>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <div class="row g-4 mt-3">
        <div class="col-12">
            <div class="card shadow-sm">
                <div class="card-header bg-primary text-white">
                    <h3 class="card-title mb-0">Bulk Add Students to Exam</h3>
                </div>
                <div class="card-body">
                    <form method="POST" action="manage_students.php" enctype="multipart/form-data">
                        <input type="hidden" name="bulk_upload" value="1">
                        <div class="mb-3">
                            <label for="bulk_exam_id" class="form-label">Select Exam</label>
                            <select class="form-select" id="bulk_exam_id" name="bulk_exam_id" required>
                                <option value="">-- Select Exam --</option>
                                <?php foreach($exams as $exam): ?>
                                <option value="<?php echo $exam['id']; ?>"><?php echo htmlspecialchars($exam['exam_name']); ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                        <div class="mb-3">
                            <label for="bulk_file" class="form-label">Upload CSV File (Student ID, Name)</label>
                            <input type="file" class="form-control" id="bulk_file" name="bulk_file" accept=".csv" required>
                        </div>
                        <button type="submit" class="btn btn-primary w-100">Upload and Assign</button>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <div class="row g-4 mt-3">
        <div class="col-12">
            <div class="card shadow-sm">
                <div class="card-header bg-primary text-white">
                    <h3 class="card-title mb-0">Exam Assignments</h3>
                </div>
                <div class="card-body p-0">
                    <?php if(empty($assignments)): ?>
                        <p class="p-3">No exam assignments found.</p>
                    <?php else: ?>
                        <table class="table table-bordered table-striped mb-0">
                            <thead>
                                <tr>
                                    <th>Student ID</th>
                                    <th>Student Name</th>
                                    <th>Exam Name</th>
                                    <th>Status</th>
                                    <th>Completed At</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach($assignments as $assign): ?>
                                <tr>
                                    <td><a href="view_student_responses.php?student_id=<?php echo urlencode($assign['student_id']); ?>&exam_id=<?php echo urlencode($assign['exam_id']); ?>"><?php echo htmlspecialchars($assign['stud_id']); ?></a></td>
                                    <td><a href="view_student_responses.php?student_id=<?php echo urlencode($assign['student_id']); ?>&exam_id=<?php echo urlencode($assign['exam_id']); ?>"><?php echo htmlspecialchars($assign['name']); ?></a></td>
                                    <td><?php echo htmlspecialchars($assign['exam_name']); ?></td>
                                    <td><?php echo htmlspecialchars($assign['status']); ?></td>
                                    <td><?php echo htmlspecialchars($assign['completed_at']); ?></td>
                                    <td>
                                        <?php if ($assign['status'] === 'completed' && canRemove($assign['completed_at'])): ?>
                                            <a href="remove_student_exam.php?assignment_id=<?php echo urlencode($assign['id']); ?>" class="btn btn-sm btn-danger" onclick="return confirm('Are you sure you want to remove this exam assignment?');" title="Remove Assignment"><i class="bi bi-trash"></i> Remove</a>
                                        <?php endif; ?>
                                        <?php if ($assign['status'] === 'completed'): ?>
                                            <form method="POST" action="manage_students.php" style="display:inline-block;margin-left:5px;">
                                                <input type="hidden" name="reapprove_exam" value="1">
                                                <input type="hidden" name="assignment_id" value="<?php echo urlencode($assign['id']); ?>">
                                                <button type="submit" class="btn btn-sm btn-warning" onclick="return confirm('Re-approve this student for the exam?');" title="Re-approve Assignment"><i class="bi bi-arrow-clockwise"></i> Re-approve</button>
                                            </form>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.js"></script>
<script>
document.querySelectorAll('.edit-btn').forEach(btn => {
    btn.addEventListener('click', () => {
        document.getElementById('student_id').value = btn.getAttribute('data-studentid');
        document.getElementById('name').value = btn.getAttribute('data-name');
    });
});
</script>
</body>
</html>
