<?php
session_start();
if (!isset($_SESSION['student_id'])) {
    header('Location: student_login.php');
    exit;
}
if (!isset($_GET['exam_id'])) {
    header('Location: student_dashboard.php');
    exit;
}
$exam_id = intval($_GET['exam_id']);
$_SESSION['exam_id'] = $exam_id;

require_once 'connectiondb.php';


try {
    $pdo = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8mb4", $user, $pass);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Check if start_time is already set for this student and exam
    $stmt = $pdo->prepare("SELECT start_time FROM student_exams WHERE student_id = ? AND exam_id = ?");
    $stmt->execute([$_SESSION['student_id'], $exam_id]);
    $row = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$row || $row['start_time'] === null) {
        // Update or insert start_time
        $updateStmt = $pdo->prepare("UPDATE student_exams SET start_time = NOW() WHERE student_id = ? AND exam_id = ?");
        $updateStmt->execute([$_SESSION['student_id'], $exam_id]);
    }
} catch (PDOException $e) {
    // Log error or handle as needed
}

header('Location: take_exam.php');
exit;
?>
