<?php
if(session_status()==PHP_SESSION_NONE){session_start();}
if(!isset($_SESSION['admin_logged_in'])||$_SESSION['admin_logged_in']!==true){header('Location: admin_login.php');exit;}
require_once 'connectiondb.php';

// Fetch exams with counts of completed submissions
$stmt=$pdo->query("SELECT e.id,e.exam_name,e.exam_code,e.created_at,COUNT(se.id) AS completed_submissions FROM exams e LEFT JOIN student_exams se ON e.id=se.exam_id AND se.status='completed' GROUP BY e.id ORDER BY e.created_at DESC");
$exams=$stmt->fetchAll(PDO::FETCH_ASSOC);

// Calculate total, active, and completed exams counts
$total_exams = count($exams);
$active_exams = 0;
$completed_exams = 0;
foreach($exams as $exam){
    if($exam['completed_submissions'] > 0){
        $completed_exams++;
    }else{
        $active_exams++;
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8"/>
<meta name="viewport" content="width=device-width, initial-scale=1"/>
<title>Admin Dashboard - MCQ Exam Portal</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet"/>
</head>
<body>
<?php include 'navbar.php'; ?>
<div class="container my-4">
    <h2>Admin Dashboard</h2>
    <div class="row mb-4">
        <div class="col-md-4">
            <div class="card text-white bg-primary mb-3">
                <div class="card-body">
                    <h5 class="card-title">Total Exams</h5>
                    <p class="card-text fs-3"><?php echo $total_exams; ?></p>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card text-white bg-success mb-3">
                <div class="card-body">
                    <h5 class="card-title">Active Exams</h5>
                    <p class="card-text fs-3"><?php echo $active_exams; ?></p>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card text-white bg-secondary mb-3">
                <div class="card-body">
                    <h5 class="card-title">Completed Exams</h5>
                    <p class="card-text fs-3"><?php echo $completed_exams; ?></p>
                </div>
            </div>
        </div>
    </div>
    <?php if(empty($exams)): ?>
        <p>No exams found.</p>
    <?php else: ?>
        <table class="table table-bordered table-striped">
            <thead>
                <tr>
                    <th>Exam Name</th>
                    <th>Exam Code</th>
                    <th>Created At</th>
                    <th>Completed Submissions</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach($exams as $exam): ?>
                <tr>
                    <td><?php echo htmlspecialchars($exam['exam_name']); ?></td>
                    <td><?php echo htmlspecialchars($exam['exam_code']); ?></td>
                    <td><?php echo htmlspecialchars($exam['created_at']); ?></td>
                    <td><?php echo $exam['completed_submissions']; ?></td>
                    <td>
                        <a href="edit_exam.php?exam_id=<?php echo $exam['id'];?>" class="btn btn-sm btn-primary me-1">Edit</a>
                        <a href="download_responses.php?exam_id=<?php echo $exam['id'];?>" class="btn btn-sm btn-secondary me-1">Download Responses</a>
                        <a href="admin_exam_students.php?exam_id=<?php echo $exam['id'];?>" class="btn btn-sm btn-info me-1">View Enrolled Students</a>
                        <a href="delete_exam.php?exam_id=<?php echo $exam['id'];?>" class="btn btn-sm btn-danger" onclick="return confirm('Are you sure you want to delete this exam? This action cannot be undone.');">Delete</a>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    <?php endif; ?>
</div>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
