<?php
session_start();

// Check if the user is logged in
if (!isset($_SESSION['user_id'])) {
    header('Location: index.php');
    exit;
}
?>

<!DOCTYPE html>
<html>
<head>
    <title>Student Registration Form</title>
    <!-- Bootstrap CSS -->
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.16.0/umd/popper.min.js"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
</head>
<body>
    <?php include('nav.php'); ?>
    <div class="container mt-5">
        <div class="row justify-content-center">
            <div class="col-md-8">
                <div class="card mb-4">
                    <div class="card-header">
                        Student Registration Form
                    </div>
                    <div class="card-body">
                        <form action="register.php" method="get">
                            <div class="form-group">
                                <label for="student_id">Student ID:</label>
                                <input type="text" name="student_id" id="student_id" class="form-control" required>
                            </div>
                            <div class="form-group">
                                <label for="student_name">Student Name:</label>
                                <input type="text" name="student_name" id="student_name" class="form-control" required>
                            </div>
                            <div class="form-group">
                                <label for="course_name">Course Name:</label>
                                <select name="course_name" id="course_name" class="form-control" required>
                                    <option value="">--Select Course--</option>
                                    <option value="CCC">CCC</option>
                                    <option value="advance-excel">Advance Excel</option>
                                    <option value="graphic-designing">Graphic Designing</option>
                                    <option value="web-design">Web Designing</option>
                                    <option value="digital-marketing">Digital Marketing</option>
                                    <option value="e-accounting">e-Accounting</option>
                                     <option value="Diploma in Computer Application">Diploma in Computer Application</option>
                                </select>
                            </div>
                            <div class="form-group">
                                <label for="mobile_number">Mobile Number:</label>
                                <input type="text" name="mobile_number" id="mobile_number" class="form-control" required>
                            </div>
                            <div class="form-group">
                                <label for="email_id">Email ID:</label>
                                <input type="email" name="email_id" id="email_id" class="form-control" required>
                            </div>
                            <div class="form-group">
                                <label for="date_of_joining">Date of Joining:</label>
                                <input type="date" name="date_of_joining" id="date_of_joining" class="form-control" required>
                            </div>

                            <div class="form-group">
                                <label for="father_name">Father's Name:</label>
                                <input type="text" name="father_name" id="father_name" class="form-control" required>
                            </div>

                            <div class="form-group">
                                <label for="mother_name">Mother's Name:</label>
                                <input type="text" name="mother_name" id="mother_name" class="form-control" required>
                            </div>

                            <div class="form-group">
                                <label for="date_of_birth">Date of Birth:</label>
                                <input type="date" name="date_of_birth" id="date_of_birth" class="form-control" required>
                            </div>

                            <div class="form-group">
                                <label for="current_address">Current Address:</label>
                                <textarea name="current_address" id="current_address" class="form-control" required></textarea>
                            </div>
                            
                            <div class="form-group">
                                <label for="permanent_address">Permanent Address:</label>
                                <textarea name="permanent_address" id="permanent_address" class="form-control" required></textarea>
                            </div>
                            
                            <div class="form-group form-check">
                                <input type="checkbox" class="form-check-input" id="copyAddress">
                                <label class="form-check-label" for="copyAddress">Copy Current Address to Permanent Address</label>
                            </div>
                            
                            <div class="form-group">
                                <label for="parents_contact_number">Parent's Contact Number:</label>
                                <input type="text" name="parents_contact_number" id="parents_contact_number" class="form-control" required>
                            </div>
                            <div class="form-group">
                                <label for="aadhaar_number">Aadhaar Number:</label>
                                <input type="text" name="aadhaar_number" id="aadhaar_number" class="form-control" required>
                            </div>
                            <button type="submit" class="btn btn-primary">Register</button>
                        </form>
                    </div>
                </div>

                <!-- CSV Upload and Download Section -->
                <div class="card">
                    <div class="card-header">
                        Bulk Upload / Download CSV
                    </div>
                    <div class="card-body">
                        <form action="register.php" method="post" enctype="multipart/form-data" class="mb-3">
                            <div class="form-group">
                                <label for="csv_file">Upload CSV File for Bulk Insert:</label>
                                <input type="file" name="csv_file" id="csv_file" accept=".csv" class="form-control-file" required>
                            </div>
                            <button type="submit" name="upload_csv" class="btn btn-success">Upload CSV</button>
                        </form>
                        <a href="register.php?download=blank_csv" class="btn btn-info">Download Blank CSV Template</a>
                    </div>
                </div>

            </div>
        </div>
    </div>

    <script>
        $(document).ready(function() {
            var previousPermanentAddress = $('#permanent_address').val();

            $('#copyAddress').change(function() {
                if ($(this).is(':checked')) {
                    previousPermanentAddress = $('#permanent_address').val();
                    $('#permanent_address').val($('#current_address').val());
                    // Removed disabling the textarea to ensure value is submitted
                } else {
                    $('#permanent_address').val(previousPermanentAddress);
                    // Keep textarea enabled
                }
            });

            $('#current_address').on('input', function() {
                if ($('#copyAddress').is(':checked')) {
                    $('#permanent_address').val($(this).val());
                }
            });
        });
    </script>

</body>
</html>
