<?php
session_start();
if (!isset($_SESSION['student_id']) || !isset($_SESSION['exam_id'])) {
    header('Location: student_login.php');
    exit;
}

$student_id = $_SESSION['student_id'];
$exam_id = $_SESSION['exam_id'];

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    header('Location: take_exam.php');
    exit;
}

$answers = $_POST['answers'] ?? [];

require_once 'connectiondb.php';

try {
    $pdo = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8mb4", $user, $pass);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Begin transaction
    $pdo->beginTransaction();

// Delete any previous answers for this student and exam
$stmt = $pdo->prepare("DELETE sa FROM student_answers sa JOIN questions q ON sa.question_id = q.id WHERE sa.student_id = ? AND q.exam_id = ?");
$stmt->execute([$student_id, $exam_id]);

$checkOptionStmt = $pdo->prepare("SELECT COUNT(*) FROM options WHERE id = ?");

$insertStmt = $pdo->prepare("INSERT INTO student_answers (student_id, question_id, selected_option_id) VALUES (?, ?, ?)");
foreach ($answers as $question_id => $option_id) {
    // Validate option_id exists
    $checkOptionStmt->execute([$option_id]);
    $count = $checkOptionStmt->fetchColumn();
    if ($count == 0) {
        // Skip invalid option_id
        continue;
    }
    $insertStmt->execute([$student_id, $question_id, $option_id]);
}

    // Update student_exams status to completed
    $updateStmt = $pdo->prepare("UPDATE student_exams SET status = 'completed', completed_at = NOW() WHERE student_id = ? AND exam_id = ?");
    $updateStmt->execute([$student_id, $exam_id]);

    $pdo->commit();

    // Clear exam_id from session
    unset($_SESSION['exam_id']);

    header('Location: exam_completed.php');
    exit;

} catch (PDOException $e) {
    if ($pdo->inTransaction()) {
        $pdo->rollBack();
    }
    die("Error submitting answers: " . $e->getMessage());
}
?>
