<?php
session_start();
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    header('Location: admin_login.php');
    exit;
}
require_once 'connectiondb.php';


try {
    $pdo = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8mb4", $user, $pass);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    die("Database connection failed: " . $e->getMessage());
}

$student_id = $_GET['student_id'] ?? '';
if (empty($student_id) || !is_numeric($student_id)) {
    die("Invalid student ID.");
}

$error = '';
$success = '';

// Fetch student details
$stmt = $pdo->prepare("SELECT * FROM students WHERE id = ?");
$stmt->execute([$student_id]);
$student = $stmt->fetch(PDO::FETCH_ASSOC);
if (!$student) {
    die("Student not found.");
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $new_student_id = trim($_POST['student_id'] ?? '');
    $new_name = trim($_POST['name'] ?? '');

    if (empty($new_student_id) || empty($new_name)) {
        $error = "Please enter both Student ID and Name.";
    } else {
        // Check if new student_id conflicts with another student
        $stmtCheck = $pdo->prepare("SELECT id FROM students WHERE student_id = ? AND id != ?");
        $stmtCheck->execute([$new_student_id, $student_id]);
        if ($stmtCheck->fetch()) {
            $error = "Student ID already exists for another student.";
        } else {
            // Update student details
            $stmtUpdate = $pdo->prepare("UPDATE students SET student_id = ?, name = ? WHERE id = ?");
            if ($stmtUpdate->execute([$new_student_id, $new_name, $student_id])) {
                $success = "Student details updated successfully.";
                // Refresh student data
                $stmt->execute([$student_id]);
                $student = $stmt->fetch(PDO::FETCH_ASSOC);
            } else {
                $error = "Failed to update student details.";
            }
        }
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8"/>
<meta name="viewport" content="width=device-width, initial-scale=1"/>
<title>Edit Student - MCQ Exam Portal</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet"/>
</head>
<body>
<?php include 'navbar.php'; ?>
<div class="container my-4">
    <h2>Edit Student</h2>
    <?php if ($error): ?>
        <div class="alert alert-danger"><?php echo htmlspecialchars($error); ?></div>
    <?php endif; ?>
    <?php if ($success): ?>
        <div class="alert alert-success"><?php echo htmlspecialchars($success); ?></div>
    <?php endif; ?>
    <form method="POST" action="edit_student.php?student_id=<?php echo urlencode($student_id); ?>">
        <div class="mb-3">
            <label for="student_id" class="form-label">Student ID</label>
            <input type="text" class="form-control" id="student_id" name="student_id" value="<?php echo htmlspecialchars($student['student_id']); ?>" required>
        </div>
        <div class="mb-3">
            <label for="name" class="form-label">Name</label>
            <input type="text" class="form-control" id="name" name="name" value="<?php echo htmlspecialchars($student['name']); ?>" required>
        </div>
        <button type="submit" class="btn btn-primary">Update Student</button>
        <a href="admin_all_students.php" class="btn btn-secondary ms-2">Back to All Students</a>
    </form>
</div>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
