<?php
if(session_status()==PHP_SESSION_NONE){session_start();}
if(!isset($_SESSION['admin_logged_in'])||$_SESSION['admin_logged_in']!==true){header('Location: admin_login.php');exit;}
require_once 'connectiondb.php';

$one_month_ago = date('Y-m-d H:i:s', strtotime('-1 month'));
// Fetch exams created within the last month with counts of completed submissions
$stmt = $pdo->prepare("SELECT e.id,e.exam_name,e.exam_code,e.created_at,COUNT(se.id) AS completed_submissions FROM exams e LEFT JOIN student_exams se ON e.id=se.exam_id AND se.status='completed' WHERE e.created_at >= ? GROUP BY e.id ORDER BY e.created_at DESC");
$stmt->execute([$one_month_ago]);
$exams = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Calculate total, active, and completed exams counts
$total_exams = count($exams);
$active_exams = 0;
$completed_exams = 0;
foreach($exams as $exam){
    if($exam['completed_submissions'] > 0){
        $completed_exams++;
    }else{
        $active_exams++;
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8"/>
<meta name="viewport" content="width=device-width, initial-scale=1"/>
<title>Admin Dashboard - MCQ Exam Portal</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet"/>
</head>
<?php include 'navbar.php'; ?>
<body>

<div class="container my-4">
    
    <h2>Admin Dashboard</h2>
    <div class="row mb-4">
        <div class="col-md-4">
            <div class="card text-white bg-primary mb-3">
                <div class="card-body">
                    <h5 class="card-title">Total Exams</h5>
                    <p class="card-text fs-3"><?php echo $total_exams; ?></p>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card text-white bg-success mb-3">
                <div class="card-body">
                    <h5 class="card-title">Active Exams</h5>
                    <p class="card-text fs-3"><?php echo $active_exams; ?></p>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card text-white bg-secondary mb-3">
                <div class="card-body">
                    <h5 class="card-title">Completed Exams</h5>
                    <p class="card-text fs-3"><?php echo $completed_exams; ?></p>
                </div>
            </div>
        </div>
    </div>

    <!-- Notification Board Section -->
    <div class="card mb-4">
        <div class="card-header">
            <h5>Notification Board</h5>
        </div>
        <div class="card-body">
            <?php
            // Fetch exams for dropdown
            $stmtExams = $pdo->query("SELECT id, exam_name FROM exams ORDER BY exam_name");
            $allExams = $stmtExams->fetchAll(PDO::FETCH_ASSOC);

            // Fetch existing notifications
            $stmtNotifs = $pdo->query("SELECT en.id, e.exam_name, en.notification_text, en.created_at FROM exam_notifications en JOIN exams e ON en.exam_id = e.id ORDER BY en.created_at DESC");
            $notifications = $stmtNotifs->fetchAll(PDO::FETCH_ASSOC);
            ?>

            <!-- Add Notification Form -->
            <form method="post" action="admin_add_notification.php" class="mb-4">
                <div class="mb-3">
                    <label for="exam_id" class="form-label">Select Exam</label>
                    <select id="exam_id" name="exam_id" class="form-select" required>
                        <option value="">-- Select Exam --</option>
                        <?php foreach ($allExams as $exam): ?>
                            <option value="<?php echo htmlspecialchars($exam['id']); ?>"><?php echo htmlspecialchars($exam['exam_name']); ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div class="mb-3">
                    <label for="notification_text" class="form-label">Notification Text</label>
                    <textarea id="notification_text" name="notification_text" class="form-control" rows="3" required></textarea>
                </div>
                <button type="submit" class="btn btn-primary">Add Notification</button>
            </form>

            <!-- Existing Notifications List -->
            <?php if (empty($notifications)): ?>
                <p>No notifications found.</p>
            <?php else: ?>
                <table class="table table-bordered">
                    <thead>
                        <tr>
                            <th>Exam</th>
                            <th>Notification</th>
                            <th>Created At</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($notifications as $notif): ?>
                        <tr>
                            <td><?php echo htmlspecialchars($notif['exam_name']); ?></td>
                            <td><?php echo nl2br(htmlspecialchars($notif['notification_text'])); ?></td>
                            <td><?php echo htmlspecialchars($notif['created_at']); ?></td>
                            <td>
                                <form method="post" action="admin_delete_notification.php" onsubmit="return confirm('Are you sure you want to delete this notification?');" style="display:inline;">
                                    <input type="hidden" name="notification_id" value="<?php echo $notif['id']; ?>" />
                                    <button type="submit" class="btn btn-sm btn-danger">Delete</button>
                                </form>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            <?php endif; ?>
        </div>
    </div>
    <div class="mb-3">
        <a href="admin_archived_exams.php" class="btn btn-outline-secondary">View Archived Exams</a>
        <a href="admin_set_student_password.php" class="btn btn-outline-primary ms-2">Set Student Passwords</a>
        <a href="admin_bulk_exam_results.php" class="btn btn-outline-primary ms-2">All Students Result</a>
    </div>
    <?php if(empty($exams)): ?>
        <p>No exams found.</p>
    <?php else: ?>
        <table class="table table-bordered table-striped">
            <thead>
                <tr>
                    <th>Exam Name</th>
                    <th>Exam Code</th>
                    <th>Created At</th>
                    <th>Completed Submissions</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach($exams as $exam): ?>
                <tr>
                    <td><?php echo htmlspecialchars($exam['exam_name']); ?></td>
                    <td><?php echo htmlspecialchars($exam['exam_code']); ?></td>
                    <td><?php echo htmlspecialchars($exam['created_at']); ?></td>
                    <td><?php echo $exam['completed_submissions']; ?></td>
                    <td>
                        <a href="edit_exam.php?exam_id=<?php echo $exam['id'];?>" class="btn btn-sm btn-primary me-1">Edit</a>
                        <a href="manage_exam_questions.php?exam_id=<?php echo $exam['id'];?>" class="btn btn-sm btn-warning me-1">Manage Questions</a>
                        <a href="download_responses.php?reexam_id=<?php echo $exam['id'];?>" class="btn btn-sm btn-secondary me-1">Download Responses</a>
                        <a href="admin_exam_students.php?exam_id=<?php echo $exam['id'];?>" class="btn btn-sm btn-info me-1">View Enrolled Students</a>
                        <a href="bulk_result_approve.php" class="btn btn-sm btn-success me-1">Bulk Result Approve</a>
                        <a href="delete_exam.php?exam_id=<?php echo $exam['id'];?>" class="btn btn-sm btn-danger" onclick="return confirm('Are you sure you want to delete this exam? This action cannot be undone.');">Delete</a>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    <?php endif; ?>
</div>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
