<?php
session_start();
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    header('Location: admin_login.php');
    exit;
}

require_once 'connectiondb.php';

if (!isset($_GET['exam_id'])) {
    die('Exam ID is required.');
}

$exam_id = intval($_GET['exam_id']);
$success_message = '';
$error_message = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $exam_name = $_POST['exam_name'] ?? '';
    $exam_code = $_POST['exam_code'] ?? '';
    $duration = $_POST['duration'] ?? null;
    $exam_month = $_POST['exam_month'] ?? null;
    $allowed_attempts = $_POST['allowed_attempts'] ?? null;

    if (empty($exam_name) || empty($exam_code) || empty($exam_month) || empty($allowed_attempts)) {
        $error_message = "Please fill all required fields including exam month and allowed attempts.";
    } else {
        try {
            $stmt = $pdo->prepare("UPDATE exams SET exam_name = ?, exam_code = ?, duration = ?, exam_month = ?, allowed_attempts = ? WHERE id = ?");
            $stmt->execute([$exam_name, $exam_code, $duration, $exam_month, $allowed_attempts, $exam_id]);
            $success_message = "Exam details updated successfully.";
        } catch (Exception $e) {
            $error_message = "Error updating exam details: " . $e->getMessage();
        }
    }
}

// Fetch exam info
$stmt = $pdo->prepare("SELECT * FROM exams WHERE id = ?");
$stmt->execute([$exam_id]);
$exam = $stmt->fetch(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <title>Edit Exam Details - Admin Panel</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet" />
    <style>
        body {
            background: linear-gradient(135deg,rgb(16, 99, 253) 0%,rgb(255, 255, 255) 100%);
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            color: #333;
        }
        .content-area {
            margin-top: 80px;
            padding: 30px 40px;
            min-height: calc(100vh - 80px);
            background: #ffffffcc;
            border-radius: 12px;
            max-width: 600px;
            margin-left: auto;
            margin-right: auto;
            box-shadow: 0 8px 24px rgba(0,0,0,0.15);
            backdrop-filter: blur(10px);
        }
        h2 {
            text-align: center;
            margin-bottom: 30px;
            color: #1a237e;
            font-weight: 800;
            font-size: 2.5rem;
            letter-spacing: 2px;
            text-shadow: 1px 1px 3px rgba(0,0,0,0.2);
        }
        label {
            font-weight: 700;
            color: #1a237e;
            font-size: 1.1rem;
        }
        input.form-control, select.form-select {
            border: 2px solid #1a237e;
            border-radius: 8px;
            padding: 10px 12px;
            font-size: 1rem;
            transition: all 0.4s ease;
        }
        input.form-control:focus, select.form-select:focus {
            border-color: #ff6f00;
            box-shadow: 0 0 12px #ff6f00aa;
            outline: none;
            background-color: #fff8e1;
        }
        button.btn-primary {
            width: 100%;
            padding: 14px;
            font-size: 1.2rem;
            font-weight: 700;
            border-radius: 10px;
            border: none;
            cursor: pointer;
            transition: all 0.4s ease;
            box-shadow: 0 4px 12px rgba(0,0,0,0.1);
            background-color: #1a237e;
            color: white;
        }
        button.btn-primary:hover {
            background-color: #0d1451;
            box-shadow: 0 6px 16px rgba(13,20,81,0.6);
        }
        .message {
            margin-bottom: 20px;
            padding: 10px;
            border-radius: 5px;
            text-align: center;
        }
        .success {
            background-color: #d4edda;
            color: #155724;
        }
        .error {
            background-color: #f8d7da;
            color: #721c24;
        }
    </style>
</head>
<body>
    <?php include 'navbar.php'; ?>
    <div class="content-area">
        <h2>Edit Exam Details</h2>
        <?php if (!empty($success_message)): ?>
            <div class="message success"><?php echo htmlspecialchars($success_message); ?></div>
        <?php endif; ?>
        <?php if (!empty($error_message)): ?>
            <div class="message error"><?php echo htmlspecialchars($error_message); ?></div>
        <?php endif; ?>
        <form method="POST" action="edit_exam.php?exam_id=<?php echo $exam_id; ?>">
            <div class="mb-3">
                <label for="exam_name">Exam Name:</label>
                <input type="text" id="exam_name" name="exam_name" class="form-control" value="<?php echo htmlspecialchars($exam['exam_name'] ?? ''); ?>" required>
            </div>
            <div class="mb-3">
                <label for="exam_code">Exam Code:</label>
                <input type="text" id="exam_code" name="exam_code" class="form-control" value="<?php echo htmlspecialchars($exam['exam_code'] ?? ''); ?>" required>
            </div>
            <div class="mb-3">
                <label for="exam_month">Exam Month:</label>
                <select id="exam_month" name="exam_month" class="form-select" required>
                    <option value="" disabled>Select month</option>
                    <?php
                    $months = ['January','February','March','April','May','June','July','August','September','October','November','December'];
                    foreach ($months as $month) {
                        $selected = ($exam['exam_month'] ?? '') === $month ? 'selected' : '';
                        echo "<option value=\"$month\" $selected>$month</option>";
                    }
                    ?>
                </select>
            </div>
            <div class="mb-3">
                <label for="duration">Duration (minutes):</label>
                <input type="number" id="duration" name="duration" min="1" max="600" class="form-control" value="<?php echo htmlspecialchars($exam['duration'] ?? ''); ?>">
            </div>
            <div class="mb-3">
                <label for="allowed_attempts">Allowed Attempts:</label>
                <input type="number" id="allowed_attempts" name="allowed_attempts" min="1" max="10" class="form-control" value="<?php echo htmlspecialchars($exam['allowed_attempts'] ?? ''); ?>" required>
            </div>
            <button type="submit" class="btn-primary">Save Changes</button>
        </form>
    </div>
</body>
</html>
