<?php
session_start();

// Database connection
require_once 'connectiondb.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $student_id = $_POST['student_id'] ?? '';
    $password = $_POST['password'] ?? '';

    if (empty($student_id) || empty($password)) {
        $error = "Please enter both Student ID and Password.";
    } else {
        // Check if student exists
        $stmt = $pdo->prepare("SELECT * FROM students WHERE student_id = ?");
        $stmt->execute([$student_id]);
        $student = $stmt->fetch(PDO::FETCH_ASSOC);

        if (!$student) {
            $error = "Invalid Student ID or Password.";
        } else {
            // Verify password (plain text comparison)
            if ($password === $student['password_hash']) {
                // Set session and redirect to student dashboard
                $_SESSION['student_id'] = $student['id'];
                header('Location: student_dashboard.php');
                exit;
            } else {
                $error = "Invalid Student ID or Password.";
            }
        }
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <title>Student Login - MCQ Exam Portal</title>
    <style>
        /* Reset some default styles */
        * {
            box-sizing: border-box;
        }
        body {
            font-family: 'Arial', sans-serif;
            background: linear-gradient(135deg, #6a11cb 0%, #2575fc 100%);
            margin: 0;
            height: 100vh;
            display: flex;
            justify-content: center;
            align-items: center;
            color: #fff;
        }
        .login-container {
            background: rgba(255, 255, 255, 0.1);
            padding: 3rem 2.5rem;
            border-radius: 15px;
            box-shadow: 0 8px 30px rgba(0, 0, 0, 0.3);
            width: 100%;
            max-width: 400px;
            text-align: center;
            backdrop-filter: blur(10px);
        }
        h2 {
            margin-bottom: 2rem;
            font-weight: 700;
            font-size: 2rem;
            letter-spacing: 1px;
            text-shadow: 0 2px 5px rgba(0,0,0,0.3);
        }
        form {
            display: flex;
            flex-direction: column;
            gap: 1.5rem;
        }
        label {
            font-weight: 600;
            text-align: left;
            color: #e0e0e0;
            font-size: 1rem;
        }
        input[type="text"],
        input[type="password"] {
            padding: 0.75rem 1rem;
            border: none;
            border-radius: 10px;
            font-size: 1rem;
            background: rgba(255, 255, 255, 0.2);
            color: #fff;
            transition: background-color 0.3s ease;
        }
        input[type="text"]:focus,
        input[type="password"]:focus {
            background: rgba(255, 255, 255, 0.35);
            outline: none;
            box-shadow: 0 0 8px rgba(255, 255, 255, 0.6);
        }
        button {
            padding: 0.85rem 1rem;
            background-color: #ff6a00;
            color: white;
            font-size: 1.1rem;
            font-weight: 700;
            border: none;
            border-radius: 10px;
            cursor: pointer;
            transition: background-color 0.3s ease;
            box-shadow: 0 4px 15px rgba(255, 106, 0, 0.4);
        }
        button:hover {
            background-color: #e65c00;
            box-shadow: 0 6px 20px rgba(230, 92, 0, 0.6);
        }
        .error-message {
            color: #ff4d4d;
            background-color: rgba(255, 77, 77, 0.2);
            border: 1px solid #ff4d4d;
            padding: 0.75rem 1rem;
            border-radius: 10px;
            margin-bottom: 1rem;
            font-weight: 600;
            text-align: left;
            box-shadow: 0 0 8px rgba(255, 77, 77, 0.5);
        }
        @media (max-width: 480px) {
            .login-container {
                padding: 2rem 1.5rem;
                margin: 0 1rem;
            }
        }
    </style>
</head>
<body>
    <div class="login-container">
        <h2>Student Login</h2>
        <?php if (!empty($error)) { echo "<div class='error-message'>$error</div>"; } ?>
        <form method="POST" action="student_login.php" novalidate>
            <label for="student_id">Student ID:</label>
            <input type="text" id="student_id" name="student_id" required autocomplete="off" />
            <label for="password">Password:</label>
            <input type="password" id="password" name="password" required autocomplete="off" />
            <button type="submit">Login</button>
        </form>
    </div>
</body>
</html>
