

<?php
// Database connection

include('panel/db.php');

try {
    $db = new PDO("mysql:host=$host;dbname=$dbname", $username, $password);
    $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    die("Database connection failed: " . $e->getMessage());
}

// Verify Certificate
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $certificate_id = $_POST['certificate_id'];

    // Check if certificate exists
    $query = "SELECT c.certificate_id, c.student_id, c.certificate_id AS certificate_number, c.grade, s.student_name, s.date_of_birth, s.date_of_joining, s.mother_name, s.father_name, s.course_name
              FROM certificates c
              JOIN students s ON c.student_id = s.student_id
              WHERE c.certificate_id = :certificate_id";
    $stmt = $db->prepare($query);
    $stmt->bindParam(':certificate_id', $certificate_id);
    $stmt->execute();
    $result = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($result) {
        $student = $result;
        $certificate = $result;
    } else {
        $student = null;
        $certificate = null;
    }
}
?>



<!DOCTYPE html>
<html>
<head>
    <title>Verify Certificate</title>
    <!-- Bootstrap CSS -->
    <!-- Favicon -->
    <link href="img/favicon.ico" rel="icon">

    <!-- Google Web Fonts -->
    <link rel="preconnect" href="https://fonts.gstatic.com">
    <link href="https://fonts.googleapis.com/css2?family=Jost:wght@500;600;700&family=Open+Sans:wght@400;600&display=swap" rel="stylesheet"> 

    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.10.0/css/all.min.css" rel="stylesheet">

    <!-- Libraries Stylesheet -->
    <link href="lib/owlcarousel/assets/owl.carousel.min.css" rel="stylesheet">

    <!-- Customized Bootstrap Stylesheet -->
    <link href="css/style.css" rel="stylesheet">

    <meta name="viewport" content="width=device-width, initial-scale=1">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <!-- Font Awesome CSS -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css">
    <!-- Custom CSS -->
    <style>
        #watermark-box {
            position: relative;
            background-image: url('https://youthpdorg.in/img/footer%20logo.png');
            background-repeat: repeat;
            background-position: center;
            background-size: 5% auto;
            background-origin: content-box;
            background-attachment: fixed;
            padding: 20px;
            border-radius: 5px;
        }
        .watermark-box::before {
            content: "";
            position: absolute;
            top: 0; left: 0; right: 0; bottom: 0;
            background-image: inherit;
            background-repeat: repeat;
            background-position: center center;
            background-size: 5% auto;
            opacity: 0.001;
            z-index: 0;
            transform: rotate(45deg);
            transform-origin: center center;
            pointer-events: none;
            filter: brightness(0.9);
        }
        .watermark-box > * {
            position: relative;
            z-index: 1;
        }
        #contain {
            max-width: 500px;
            margin-top: 50px;
        }

        #contain h2 {
            text-align: center;
            margin-bottom: 20px;
            color: #333;
        }

        #form_group {
            margin-bottom: 20px;
        }

        #form_group label {
            font-weight: bold;
            color: #555;
        }

        .btn-primary {
            background-color: #007bff;
            border-color: #007bff;
        }

        .btn-primary:hover {
            background-color: #0069d9;
            border-color: #0069d9;
        }

        .alert {
            margin-top: 20px;
            text-align: center;
        }
       

        #alert i {
            font-size: 48px;
            margin-bottom: 10px;
        }

        .alert-success {
            color: #155724;
            background-color: #d4edda;
            border-color: #c3e6cb;
        }

        .alert-danger {
            color: #721c24;
            background-color: #f8d7da;
            border-color: #f5c6cb;
        }
    </style>
</head>
<body>
     <?php include 'header.php';?>
    <div class="container" id="contain">
        <h2>Verify Certificate</h2>
        <form method="POST">
            <div class="form-group" id="form_group">
                <label for="certificate_id">Certificate ID:</label>
                <input type="text" class="form-control" id="certificate_id" name="certificate_id" required>
            </div>
            <button type="submit" class="btn btn-primary"><i class="fas fa-search"></i> Verify</button>
        </form>

        <?php if ($_SERVER['REQUEST_METHOD'] === 'POST'): ?>
            <?php if ($certificate): ?>
            <div class="alert alert-primary text-white watermark-box" role="alert" id="watermark-box">
                <img src="https://youthpdorg.in/img/logo.png" alt="Logo" style="display: block; margin: 0 auto 35px; max-width: 200px;">
            <h1 class="text-success"><i class="fas fa-check-circle"></i> Congratulations!! <br> Certificate is valid! </h1>
                <div class="mt-3">
					<table class="table">
						<tr>
							<th>Student ID</th>
							<td><?php echo $student['student_id']; ?></td>
						</tr>   
						<tr>
							<th>Student Name</th>
							<td><?php echo $student['student_name']; ?></td>
						</tr>
						<tr>
							<th>Father's Name</th>
							<td><?php echo $student['father_name']; ?></td>
						</tr>
						<tr>
							<th>Mother's Name</th>
							<td><?php echo $student['mother_name']; ?></td>
						</tr>
						<tr>
							<th>Date of Birth</th>
							<td><?php echo $student['date_of_birth']; ?></td>
						</tr>
						<tr>
							<th>Date of Completion</th>
							<td><?php echo $student['date_of_joining']; ?></td>
						</tr>
						<tr>
							<th>Certificate Number</th>
							<td><?php echo $certificate['certificate_number']; ?></td>
						</tr>
						<tr>
							<th>Course Name</th>
							<td><?php echo $student['course_name']; ?></td>
						</tr>
						<tr>
							<th>Grade</th>
							<td><?php echo $student['grade']; ?></td>
						</tr>
					</table>
				</div>
            </div>
            <?php else: ?>
                <div class="alert alert-danger" role="alert" id="alert">
                    <h1><i class="fas fa-times-circle"></i> Invalid Certificate</h1>
                </div>
            <?php endif; ?>
        <?php endif; ?>
    </div>
     <div class="col-md-12">
                    <div class="panel panel-default academic-panel" id="box">
                        <div class="col-sm-12 col-md-8 col-lg-12 well">
                            
                            <div class="col-sm-12 col-md-8 col-lg-12 well">
     <div class="panel-body">
           <hr class="colorgraph"/>
                            <p style="font-size: 16px;"><b style="color: red;font-size: 18px;">Note:-</b> This is the diploma and certificate verification page where you can check the diploma or certificate issued by <b>YPDO</b> or someone has made it illegally. To check it, enter the student’s Certificate number in the search box and if student details come out and match to information of student which you have in the form of diploma or certificate then it is real otherwise someone has made it to cheat. </p>
</div>


</div>

</div>
<div class="container my-4">
        <h4>Grading Criteria</h4>
        <ul>
            <li>0-40% = Below Average (C)</li>
            <li>41-60% = Average (B)</li>
            <li>61-70% = Good (B+)</li>
            <li>71-80% = Very Good (A)</li>
            <li>81-90% = Excellent (A+)</li>
            <li>91-100% = Outstanding (O)</li>
        </ul>
    </div>

</div>
<div class="container my-4">
 <a href="generate-certificate.php">Download Certificate</a>
</div>
</div>
    <!-- Bootstrap JS -->
    <!--<script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>-->
    <!-- Font Awesome JS -->
    <!--<script src="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/js/all.min.js"></script>-->
    
    <?php include 'footer.php';?>
</body>


</html>
