




<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require(__DIR__ . '/fpdf/fpdf.php'); // Include FPDF library from fpdf directory

include(__DIR__ . '/panel/db.php');

function generatePDF($certificate) {
    $pdf = new FPDF('L', 'mm', 'A4');
    $pdf->AddPage();

    // Set certificate image as background
    $certificateImagePath = __DIR__ . '/panel/demo final_page-0001-min.jpg';
    if (file_exists($certificateImagePath)) {
        $pdf->Image($certificateImagePath, 0, 0, $pdf->GetPageWidth(), $pdf->GetPageHeight());
    }

    // Set font and color
    $pdf->SetTextColor(0, 0, 0);

    $pageWidth = $pdf->GetPageWidth();
    $leftMargin = 20;
    $rightMargin = 20;
     $Margin = 20;
    $usableWidth = $pageWidth - $leftMargin - $rightMargin;

    $pdf->SetLeftMargin($leftMargin);
    $pdf->SetRightMargin($rightMargin);

    $y = 95;
    $lineHeight = 4;

    // // Paragraph 1
    // $pdf->SetFont('Arial', '', 14);
    // $pdf->SetXY($leftMargin, $y);
    // $pdf->MultiCell($usableWidth, $lineHeight, 'This is to certify that Mr./Ms./Mrs. ' . $certificate['student_name'], 0, 'C');

// Paragraph 1 with bold name and centered text
$prefix = 'This is to certify that Mr./Ms./Mrs. ';
$name = $certificate['student_name'];

$pdf->SetFont('Arial', '', 14);
$prefixWidth = $pdf->GetStringWidth($prefix);

$pdf->SetFont('Arial', 'B', 14);
$nameWidth = $pdf->GetStringWidth($name);

$totalWidth = $prefixWidth + $nameWidth;
$centerX = ($pdf->GetPageWidth() - $totalWidth) / 2;

$y += 12; // adjust Y position if needed
$pdf->SetXY($centerX, $y);

// Print prefix
$pdf->SetFont('Arial', '', 14);
$pdf->Cell($prefixWidth, $lineHeight, $prefix, 0, 0);

// Print name in bold
$pdf->SetFont('Arial', 'B', 14);
$pdf->Cell($nameWidth, $lineHeight, $name, 0, 1);


    // // Paragraph 2
    // $y += 12;
    // $pdf->SetFont('Arial', '', 14);
    // $pdf->SetXY($leftMargin, $y);
    // $pdf->MultiCell($usableWidth, $lineHeight, 'Son / Daughter / Wife of Shri ' . $certificate['father_name'], 0, 'C');

    // // Paragraph 3
    // $y += 12;
    // $pdf->SetFont('Arial', '', 14);
    // $pdf->SetXY($leftMargin, $y);
    // $pdf->MultiCell($usableWidth, $lineHeight, 'he/she has Secured grade: ' . $certificate['grade'], 0, 'C');
    
//     // Combined Paragraph
// $y += 12;
// $pdf->SetFont('Arial', '', 14);
// $pdf->SetXY($leftMargin, $y);
// $text = 'Son / Daughter / Wife of Shri ' . $certificate['father_name'] . ' has secured grade: ' . $certificate['grade'];
// $pdf->MultiCell($usableWidth, $lineHeight, $text, 0, 'C');


// Combined paragraph: Bold father's name and grade, centered
$prefix1 = 'Son / Daughter / Wife of Shri ';
$bold1 = $certificate['father_name'];
$prefix2 = ' has secured grade:  '; 
$bold2 = $certificate['grade'];

// Set font and calculate widths
$pdf->SetFont('Arial', '', 14);
$prefix1Width = $pdf->GetStringWidth($prefix1);

$pdf->SetFont('Arial', 'B', 14);
$bold1Width = $pdf->GetStringWidth($bold1);

$pdf->SetFont('Arial', '', 14);
$prefix2Width = $pdf->GetStringWidth($prefix2);

$pdf->SetFont('Arial', 'B', 14);
$bold2Width = $pdf->GetStringWidth($bold2);

// Total width of the full sentence
$totalWidth = $prefix1Width + $bold1Width + $prefix2Width + $bold2Width;

// Center position calculation
$centerX = ($pdf->GetPageWidth() - $totalWidth) / 2;

// Set Y position and start printing
$y += 12;
$pdf->SetXY($centerX, $y);

// Print each part
$pdf->SetFont('Arial', '', 14);
$pdf->Cell($prefix1Width, $lineHeight, $prefix1, 0, 0);

$pdf->SetFont('Arial', 'B', 14);
$pdf->Cell($bold1Width, $lineHeight, $bold1, 0, 0);

$pdf->SetFont('Arial', '', 14);
$pdf->Cell($prefix2Width, $lineHeight, $prefix2, 0, 0);

$pdf->SetFont('Arial', 'B', 14);
$pdf->Cell($bold2Width, $lineHeight, $bold2, 0, 1); // move to next line





    // // Paragraph 4
    // $y += 12;
    // $pdf->SetFont('Arial', '', 14);
    // $pdf->SetXY($leftMargin, $y);
    // $pdf->MultiCell($usableWidth, $lineHeight, 'has successfully cleared the assessment for the course of ' . $certificate['course_name'], 0, 'C');

   // Paragraph 4 with bold course name and centered text
$prefix = 'has successfully cleared the assessment for the course of ';
$boldCourse = $certificate['course_name'];

// Calculate widths
$pdf->SetFont('Arial', '', 14);
$prefixWidth = $pdf->GetStringWidth($prefix);

$pdf->SetFont('Arial', 'B', 14);
$courseWidth = $pdf->GetStringWidth($boldCourse);

$totalWidth = $prefixWidth + $courseWidth;
$centerX = ($pdf->GetPageWidth() - $totalWidth) / 2;

// Set Y position and print
$y += 12;
$pdf->SetXY($centerX, $y);

// Print prefix
$pdf->SetFont('Arial', '', 14);
$pdf->Cell($prefixWidth, $lineHeight, $prefix, 0, 0);

// Print bold course name
$pdf->SetFont('Arial', 'B', 14);
$pdf->Cell($courseWidth, $lineHeight, $boldCourse, 0, 1); // move to next line

   
   
   
   
   

    // // Paragraph 5
    // $y += 12;
    // $pdf->SetFont('Arial', '', 14);
    // $pdf->SetXY($leftMargin, $y);
    // $pdf->MultiCell($usableWidth, $lineHeight, 'at ' . $certificate['date_of_joining'] , 0, 'C');
    
    
    //  // Paragraph 5
    // $y += 12;
    // $pdf->SetFont('Arial', '', 14);
    // $pdf->SetXY($leftMargin, $y);
    // $pdf->MultiCell($usableWidth, $lineHeight, 'Certificate Id is ' . $certificate['certificate_id'], 0, 'C');


// // Combined Paragraph
// $y += 12;
// $pdf->SetFont('Arial', '', 14);
// $pdf->SetXY($leftMargin, $y);
// $text = 'at ' . $certificate['date_of_joining'] . ' . Certificate Id is ' . $certificate['certificate_id'];
// $pdf->MultiCell($usableWidth, $lineHeight, $text, 0, 'C');


// Combined paragraph: Bold date and certificate ID, centered
$prefix1 = 'at ';
$bold1 = $certificate['date_of_joining'];
$middle = '. Certificate Id is ';
$bold2 = $certificate['certificate_id'];

// Calculate widths
$pdf->SetFont('Arial', '', 14);
$prefix1Width = $pdf->GetStringWidth($prefix1);

$pdf->SetFont('Arial', 'B', 14);
$bold1Width = $pdf->GetStringWidth($bold1);

$pdf->SetFont('Arial', '', 14);
$middleWidth = $pdf->GetStringWidth($middle);

$pdf->SetFont('Arial', 'B', 14);
$bold2Width = $pdf->GetStringWidth($bold2);

$totalWidth = $prefix1Width + $bold1Width + $middleWidth + $bold2Width;
$centerX = ($pdf->GetPageWidth() - $totalWidth) / 2;

// Set Y position
$y += 12;
$pdf->SetXY($centerX, $y);

// Print each part
$pdf->SetFont('Arial', '', 14);
$pdf->Cell($prefix1Width, $lineHeight, $prefix1, 0, 0);

$pdf->SetFont('Arial', 'B', 14);
$pdf->Cell($bold1Width, $lineHeight, $bold1, 0, 0);

$pdf->SetFont('Arial', '', 14);
$pdf->Cell($middleWidth, $lineHeight, $middle, 0, 0);

$pdf->SetFont('Arial', 'B', 14);
$pdf->Cell($bold2Width, $lineHeight, $bold2, 0, 1); // move to next line


    // Output PDF for download
    $pdf->Output('D', 'certificate.pdf');
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $student_name = trim($_POST['student_name'] ?? '');
    $date_of_birth = trim($_POST['date_of_birth'] ?? '');
    $download_pdf = isset($_POST['download_pdf']) ? true : false;

    if (empty($student_name) || empty($date_of_birth)) {
        die('Student name and date of birth are required.');
    }

    try {
        $db = new PDO("mysql:host=$host;dbname=$dbname", $username, $password);
        $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

        // Fetch certificate and student details
        $query = "SELECT c.certificate_id, c.grade, c.date_of_joining, s.student_name, s.father_name, s.course_name
                  FROM certificates c
                  JOIN students s ON c.student_id = s.student_id
                  WHERE s.student_name = :student_name AND s.date_of_birth = :dob";
        $stmt = $db->prepare($query);
        $stmt->bindParam(':student_name', $student_name);
        $stmt->bindParam(':dob', $date_of_birth);
        $stmt->execute();
        $certificate = $stmt->fetch(PDO::FETCH_ASSOC);

        if (!$certificate) {
            die('Certificate not found.');
        }

        if ($download_pdf) {
            // Generate and download PDF
            generatePDF($certificate);
        } else {
            // Show preview HTML
            ?>
            <!DOCTYPE html>
            <html>
            <head>
                <title>Certificate Preview</title>
                <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
                <style>
                    .certificate-container {
                        position: relative;
                        width: 1000px;
                         height: 550px;
                        max-width: 100%;
                        margin: 30px auto;
                        padding: 40px;
                        background-image: url('panel/demo final_page-0001-min.jpg');
                        background-size: cover;
                        background-position: center;
                        background-repeat: no-repeat;
                        border-radius: 5px;
                        box-shadow: 0 0 15px rgba(0,0,0,0.3);
                        color: #333;
                        font-family: 'Arial', sans-serif;
                    }
                    .certificate-content {
                        position: relative;
                        background-color: rgba(255, 255, 255, 0.85);
                        padding: 20px 40px;
                        border-radius: 10px;
                    }
                    .certificate-header {
                        text-align: center;
                        margin-bottom: 220px;
                    }
                    .certificate-header img {
                        max-width: 150px;
                        margin-bottom: 15px;
                    }
                    .certificate-header h1 {
                        font-size: 28px;
                        font-weight: bold;
                        color: #2c3e50;
                    }
                    .certificate-table {
                        width: 100%;
                        margin-bottom: 30px;
                    }
                    .certificate-table th, .certificate-table td {
                        padding: 10px 15px;
                        text-align: left;
                        border-bottom: 1px solid #ddd;
                    }
                    .certificate-table th {
                        width: 40%;
                        font-weight: 600;
                        color: #34495e;
                    }
                    .btn-group {
                        text-align: center;
                        margin-bottom: -300px;
                        margin-left: 250px;
                      
                    }
                    .btn-group button {
                        margin: 0 10px;
                    }
                </style>
            </head>
            <body>
            <div class="container">
                <h2 class="text-center mt-4">Certificate Preview</h2>
                <div class="certificate-container">
                    
                        <div class="certificate-header">
                            
                        </div>
                        <p style="text-align:center;">This is to certify that Mr./Ms./Mrs. <b><?php echo htmlspecialchars($certificate['student_name']); ?></b></p>
                        <p style="text-align:center;">Son / Daughter / Wife of Shri <b><?php echo htmlspecialchars($certificate['father_name']); ?></b></p>
                        <p style="text-align:center;">Grade:  <b><?php echo htmlspecialchars($certificate['grade']); ?></b></p>
                        <p style="text-align:center;">has successfully cleared the assessment  <b><?php echo htmlspecialchars($certificate['course_name']); ?></b></p>
                      
                        <p style="text-align:center;">at <b><?php echo htmlspecialchars($certificate['date_of_joining']); ?></b></p>
                        <div class="btn-group">
                            <form method="POST" style="display:inline;">
                                <input type="hidden" name="student_name" value="<?php echo htmlspecialchars($student_name); ?>">
                                <input type="hidden" name="date_of_birth" value="<?php echo htmlspecialchars($date_of_birth); ?>">
                                <input type="hidden" name="download_pdf" value="1">
                                <button type="submit" class="btn btn-primary">Download PDF</button>
                            </form>
                     
                    </div>
                </div>
            </div>
            </body>
            </html>
            <?php
        }
    } catch (PDOException $e) {
        die('Database error: ' . $e->getMessage());
    }
} else {
    // Show a simple form to input name and date of birth
    ?>
    <!DOCTYPE html>
    <html>
    <head>
        <title>Generate Certificate PDF</title>
        <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    </head>
    <body>
    <div class="container mt-5">
        <h2>Generate Certificate PDF</h2>
        <form method="POST">
            <div class="form-group">
                <label for="student_name">Student Name</label>
                <input type="text" class="form-control" id="student_name" name="student_name" required>
            </div>
            <div class="form-group">
                <label for="date_of_birth">Date of Birth</label>
                <input type="date" class="form-control" id="date_of_birth" name="date_of_birth" required>
            </div>
            <button type="submit" class="btn btn-primary">Preview Certificate</button>
        </form>
    </div>
    </body>
    </html>
    <?php
}
?>






